﻿/*
VERSION:		2.1

2.1		added onAnimDone() callback function into returned loader object
2.0		detects successful linkage even if movieClip is empty
1.9		waitForLoad() & waitForAnim()	chain-able monads.  Reliable & instant movieClip replacement with onUnload() call.
1.8		used "function" prefix to allow local scoping
1.7		output "loader" includes a reference to the new movieClip as a variable named "content"
1.6		onLoadInit() passes a reference to the loaded movieClip
1.5		added "isVisible" flag to set the default visibility of the loaded image  (doesn't apply when result is BitmapData)


"EVENT" FUNCTIONS:
	onLoadInit
	onLoadError
	onAnimDone

	
RETURN VALUES:
	{
		onLoadInit()		Externally-defired callback function, which runs when the file is successfully loaded
		onLoadError()		Externally-defired callback function, which runs if the file cannot be loaded
		onAnimDone()		Externally-defired callback function, which runs the first time the loaded file reaches its last animation frame
		content					Reference to the internally created/loaded movieClip/image
		waitForLoad()		Adds functions to a queue which fires when the file has been loaded, or instantly if the file has already loaded
		waitForAnim()		Adds functions to a queue which fires the first time the loaded file reaches its last animation frame
	}
	
	
DESCRIPTION:
	Creates a movieClip as specified & loads an image, SWF, or bitmapData into it.
	The returned "loader" has chain-able functions:  waitForLoad  &  waitForAnim  (they're not promises, but they behave sort of like that)
	
	
DEFAULT RESULT:
	this.image_0
	
	
USAGE:
	#include "loadImage.as"
	loader = loadImage("test.jpg");
	
	loader
	.waitForLoad( success )
	.waitForAnim( onAnimDone )
	.waitForLoad( success2 );
	
	success = function( mc ){
		trace("success");
	}
	loader.onLoadInit = success;
	loader.onLoadError = function(){
		trace("fail");
	}
	
	function onAnimDone( mc ){}
*/
function loadImage(file, target, newName, newDepth, isVisible)
{
	#include "nextDepth.as"
	
	function once( func ){
		var done = false;
		return function () {
			return done ? void 0 : ((done = true), func.apply(this, arguments));
		}
	}// once()
	
	
	// chain-able monad callbacks
	//if( isLoaded )					waitForLoad_trigger();
	//if( isDoneAnimating )		waitForAnim_trigger();
	var isLoaded = false;
	var isDoneAnimating = false;
	var waitForLoad_queue = [];
	var waitForAnim_queue = [];
	var waitForLoad_trigger = function(){
		for(var i=0; i<waitForLoad_queue.length; i++){
			//waitForLoad_queue[i]( return_obj.content );
			waitForLoad_queue[i].apply( return_obj.content, [return_obj.content] );
		}// for:  each callback in thie queue
		waitForLoad_queue.splice(0, waitForLoad_queue.length);
	}
	var waitForAnim_trigger = function(){
		for(var i=0; i<waitForAnim_queue.length; i++){
			//waitForAnim_queue[i]( return_obj.content );
			waitForAnim_queue[i].apply( return_obj.content, [return_obj.content] );
		}// for:  each callback in thie queue
		waitForAnim_queue.splice(0, waitForAnim_queue.length);
	}
	// monad interface
	var return_obj = {
		onLoadInit:function(){},
		onLoadError:function(){},
		onAnimDone:function(){},
		content: undefined,
		waitForLoad: function( newCallback ){
			if(isLoaded){
				newCallback.apply( return_obj.content, [return_obj.content] );
			}else{
				waitForLoad_queue.push( newCallback );
			}
			return return_obj;		// return parent object, making this a chain-able monad
		},
		waitForAnim: function( newCallback ){
			if( isDoneAnimating ){
				newCallback.apply( return_obj.content, [return_obj.content] );
			}else{
				waitForAnim_queue.push( newCallback );
			}
			return return_obj;		// return parent object, making this a chain-able monad
		}
	}// return_obj
	
	
	var detectLastFrame_interval = null;
	var detectLastFrame = function( anim_mc ){
		// detect last animation frame
		var detectLastFrame = {
			loop:function(){
				//var anim_mc = target[newName];
				if( anim_mc._currentframe==0  ||  anim_mc._currentframe==undefined )
				{// if:  this clip was deleted
					// stop checking
					clearInterval( detectLastFrame_interval );
					// clear the queue
					waitForAnim_queue.splice(0, waitForAnim_queue.length);
				}// if:  this clip was deleted
				else if(anim_mc._currentframe == anim_mc._totalframes)
				{// if:  this clip is on its last animation frame
					// stop checking
					clearInterval( detectLastFrame_interval );
					// trigger the queue
					isDoneAnimating = true;
					waitForAnim_trigger();
					return_obj.onAnimDone( return_obj.content );
					delete return_obj.onAnimDone;
					// clear the queue
					waitForAnim_queue.splice(0, waitForAnim_queue.length);
				}// if:  this clip is on its last animation frame
			}// loop()
		}// detectLastFrame obj
		detectLastFrame_interval = setInterval( detectLastFrame.loop, 33 );
		detectLastFrame.loop();
	}// detectLastFrame()
	detectLastFrame = once( detectLastFrame );
	
	
	if(isVisible == undefined)		isVisible = true;
	// resolve optional parameters
	var target = (target) ? target : this;
	var newDepth = (newDepth!=undefined) ? newDepth : nextDepth(target);
	var newName = (newName) ? newName : "image_"+newDepth;
	if(target[newName]){
		target[newName].onUnload();
		delete target[newName].onUnload;		// prevent unload delay  &  double-calls
		target[newName].removeMovieClip();		target[newName].unloadMovie();
	}
	
	
	
	// try movieClip linkage  &  create container
	var newImage = target.attachMovie( file, newName, newDepth, {_visible:isVisible} );
	var newImage = target[newName];
	//if( newImage._width > 0  &&  newImage != target)
	if( target.getInstanceAtDepth(newDepth) !== undefined  &&  newImage != target )
	{// if:  movieClip loaded
		//trace("* MovieClip linkage");
		return_obj.content = newImage;
		isLoaded = true;
		waitForLoad_trigger();
		detectLastFrame( target[newName] );
		setTimeout( function(){
			return_obj["onLoadInit"]( loadedClip );
		}, 0 );
	}// if:  movieClip loaded
	
	
	
	// try bitmapData linkage or reference
	else
	//if(	newImage == target  ||
	//	 	newImage._width == undefined  ||
	//		newImage._width == 0)
	{// if:  no movieClip loaded
		// create container
		var newImage = target.createEmptyMovieClip(newName, newDepth);
		newImage._visible = isVisible;
		// // direct bitmapData
		if(file.generateFilterRect != undefined)
			var image_pic = file;
		// bitmap linkage
		if(file.generateFilterRect == undefined)
			var image_pic = flash.display.BitmapData.loadBitmap( file );
		
		newImage.attachBitmap(image_pic, 0, true, true);
		//if( newImage._width > 0 )
		if( newImage.getInstanceAtDepth(0) !== undefined )
		{// if:  bitmap loaded
			//trace("* Bitmap linkage");
			return_obj.content = newImage;
			isLoaded = true;
			waitForLoad_trigger();
			// bitmaps don't animate, so the animation is now done  (last frame is already displayed)
			isDoneAnimating = true;
			waitForAnim_trigger();
			return_obj.onAnimDone( return_obj.content );
			delete return_obj.onAnimDone;
			setTimeout( function(){
				return_obj["onLoadInit"]( loadedClip );
			}, 0 );
		}// if:  bitmap loaded
		
		
		
		// try loading external file
		else
		//if(	newImage._width == undefined  ||
		//newImage._width == 0)
		{// if:  no bitmap loaded
			// external file
			var loader = new MovieClipLoader();
			return_obj.content = newImage;
			
			loader.onLoadInit = function( loadedClip ){
				//trace("* File loaded");
				newImage._visible = isVisible;
				return_obj.content = loadedClip;
				isLoaded = true;
				waitForLoad_trigger();
				detectLastFrame( loadedClip );
				setTimeout( function(){
					return_obj["onLoadInit"]( loadedClip );
				}, 0 );
			}// onLoadInit()
			loader.onLoadInit = once( loader.onLoadInit );
			loader.onLoadError = function(){
				return_obj["onLoadError"]();
				// clear the current queue because it won't be needed
				waitForLoad_queue.splice(0, waitForLoad_queue.length);
				waitForAnim_queue.splice(0, waitForAnim_queue.length);
			}// onLoadError()
			loader.onLoadError = once( loader.onLoadError );
			loader.loadClip( file, newImage );
			
			if(isLoaded)
			{// if:  instant load
				// pretend that it's not instant
				setTimeout( function(){
					loader.onLoadInit( target[newName] );
				}, 0);
			}// if:  instant load			
			//return return_obj;
			//return loader;
		}// if:  no bitmap loaded
	}// if:  no movieClip loaded
	return return_obj;
}// loadImage()